%Numericka integracija - MDOF sistem

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Ciscenje radnog prostora
clear; clc;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Kondenzovana matrica krutosti
%alfa[rad]=alfa[stepenima]*pi/180
%Stap 1 - matrica krutosti i kodni brojevi u GKS
[mk_1_LKS, mk_1_GKS, m_T_1]=mk_Stapa(33*10^6, 0.3*1^3/12, 0.3*1, 4, 90*pi/180, 'k');
ss1=[1 2 3 4 5 6];
%Stap 2 - matrica krutosti i kodni brojevi u GKS
[mk_2_LKS, mk_2_GKS, m_T_2]=mk_Stapa(33*10^6, 0.3*1^3/12, 0.3*1, 3, 90*pi/180, 'k');
ss2=[4 5 6 7 8 9];
%Stap 3 - matrica krutosti i kodni brojevi u GKS
[mk_3_LKS, mk_3_GKS, m_T_3]=mk_Stapa(33*10^6, 0.3*1^3/12, 0.3*1, 3, 90*pi/180, 'k');
ss3=[7 8 9 10 11 12];
%Bitni stepeni slobode
bs=[4 7 10];
%Nebitni stepeni slobode
ns=[5 6 8 9 11 12];
%Niz nizova stepeni slobode stapova
niz_SSS={ss1 ss2 ss3};
%Niz matrica krutosti stapova
niz_MKS={mk_1_GKS mk_2_GKS mk_3_GKS};
%Matrice krutosti sistema Kbb, Kbn, Knb i Knn
Kbb=mk_Sistema(niz_SSS, niz_MKS, bs, bs);
Kbn=mk_Sistema(niz_SSS, niz_MKS, bs, ns);
Knb=mk_Sistema(niz_SSS, niz_MKS, ns, bs);
Knn=mk_Sistema(niz_SSS, niz_MKS, ns, ns);
%Kondenzovana matrica
K=Kbb-Kbn*Knn^(-1)*Knb;
disp('K =');disp(K);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Matrica masa
M=[40.0 0.0  0.0;
    0.0 40.0 0.0;
    0.0 0.0  30.0];
MInv=M^-1;
disp('M =');disp(M);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Izbor tipa numericke intergacije
%Metoda centralnih razlika -> 1 (uslovno stabilna: dt<=Tn/pi)
%NEWMARK a=const -> 2 (bezuslovno stabilan)
tipNumerickeInteracije = 2;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Interval numericke integracije
dt=0.005;
%Komentar: preporuka dt<Ti/10
%T1=0.41s (T1/10=0.041s) T2=0.06s (T2/10=0.006s) T3=0.02s (T3/10=0.002s!!!)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Formiranje vektora sila
%Trajanje analize = (brojPodataka-1)*dt = (2000-1)*0.005 = 9.995s
brojPodataka = 2001;%da bi imali i 0s i 10s
brojStepeniSlobode=size(K,1);
P=zeros(brojStepeniSlobode,brojPodataka);
%Proizvoljna sila
%Sila uz stepen slobode 1
%Linearno raste od 0.0kN u t=0.0s do 200kN u t=0.1s
for k = 1:1:21
    P(1,k)=(200/0.1)*(k-1)*dt;
end
%Konstantna vrednost 200kN do t=0.2s
for k = 22:1:41
    P(1,k)=200.0;
end
%Linearno opada od 200kN u t=0.2s do 0.0kN u t=10s
for k = 42:1:61
    P(1,k)=-(200/0.1)*(k-1)*dt+600;
end
%Konstantna vrednost 0.0kN u t=0.3s do t=10s
for k = 62:1:brojPodataka
    P(1,k)=0.0;
end
%Sila uz stepen slobode 2
for k = 1:1:brojPodataka
    P(2,k)=0.0;
end
%Sila uz stepen slobode 3
for k = 1:1:brojPodataka
    P(3,k)=0.0;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Matrica prigusenja
%Svojstvene vrednosti
if brojStepeniSlobode == 1
    omega=sqrt(eig(K,M));
    T=2*pi/omega(1); ceta=0.05;
    C=[2*ceta*omega(1)*M(1,1)];
    fprintf('T = %.5f s\n\n',T);
else
    omega=sort(sqrt(eig(K,M)),'ascend');
    T1=2*pi/omega(1); ceta1=0.05;
    T2=2*pi/omega(2); ceta2=0.05;
    fprintf('T1 = %.5f s\nT2 = %.5f s\n\n',T1,T2);
    a0=4*pi*(T1*ceta1-T2*ceta2)/(T1^2-T2^2);
    a1=(1/pi)*T1*T2*(T1*ceta1-T2*ceta2)/(T1^2-T2^2);
    C=a0*M+a1*K;
    disp('a0 =');disp(a0);
    disp('a1 =');disp(a1);
end
disp('C = a0*M + a1*K');disp(C);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Pocetni uslovi
U=zeros(brojStepeniSlobode,brojPodataka);
V=zeros(brojStepeniSlobode,brojPodataka);
A=zeros(brojStepeniSlobode,brojPodataka);
for k = 1:1:brojStepeniSlobode
    %Pocetno pomeranje
    U(k,1)=0;
    %Pocetna brzina
    V(k,1)=0;
end
    %Pocetno ubrzanje
    A(:,1)=MInv*(P(:,1)-C*V(:,1)-K*U(:,1));

%Priprema za metodu centralnih razlika i Newmark a=const.
Qkzam=zeros(brojStepeniSlobode,brojPodataka);
MatricaUzPomeranjePrethodno=(1/dt^2)*M-(1/(2*dt))*C;
MatricaUzPomeranjeTrenutno=K-(2/dt^2)*M;
if tipNumerickeInteracije == 1
    %Priprema za metodu centralnih razlika
    Kzam=(1/dt^2)*M+(1/(2*dt))*C;
    KzamInv=Kzam^-1;
    Urfiktivno(:,1)=U(:,1)-dt*V(:,1)+(dt^2/2)*A(:,1);
%Priprema za NEWMARK a=const
elseif tipNumerickeInteracije == 2    
    Kzam=K+(4/dt^2)*M+(2/dt)*C;
    KzamInv=Kzam^-1;
end

%Vektor vrsta vremenskih trenutaka numericke integracije
vektorVremenskihTrenutaka=zeros(brojPodataka,1);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Numericka integracija
for k = 1:1:(brojPodataka-1)
    %Metoda centralnih razlika
    if tipNumerickeInteracije == 1
        if k == 1
            Qkzam(:,k)=P(:,k)-MatricaUzPomeranjePrethodno*Urfiktivno(:,1)-...
                       MatricaUzPomeranjeTrenutno*U(:,k);
            U(:,k+1)=KzamInv*Qkzam(:,k);
            V(:,k)=(1/(2*dt))*(U(:,k+1)-Urfiktivno(:,1));
            A(:,k)=(1/dt^2)*(U(:,k+1)-2*U(:,k)+Urfiktivno(:,1));        
        else
            Qkzam(:,k)=P(:,k)-MatricaUzPomeranjePrethodno*U(:,k-1)-...
                       MatricaUzPomeranjeTrenutno*U(:,k);
            U(:,k+1)=KzamInv*Qkzam(:,k);
            V(:,k)=(1/(2*dt))*(U(:,k+1)-U(:,k-1));
            A(:,k)=(1/dt^2)*(U(:,k+1)-2*U(:,k)+U(:,k-1));
        end
    %NEWMARK a=const
    elseif tipNumerickeInteracije == 2
        vektorZamenjujucegOpterecenja=P(:,k+1)-P(:,k)+...
                                      M*((4/dt)*V(:,k)+...
                                      2*A(:,k))+2*C*V(:,k);
        deltaUr=KzamInv*vektorZamenjujucegOpterecenja;
        U(:,k+1)=U(:,k)+deltaUr;
        V(:,k+1)=(2/dt)*deltaUr-V(:,k);
%         A(:,k+1)=(4/dt^2)*(U(:,k+1))-...
%                  (4/dt^2)*(U(:,k))-...
%                  (4/dt)*(V(:,k))-A(:,k);
        A(:,k+1)=(4/dt^2)*deltaUr-(4/dt)*(V(:,k))-A(:,k);
    end    
    vektorVremenskihTrenutaka(k+1,1)=k*dt;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Grafici
%Pomeranje
figure('Name','Odgovor - direktna integracija','NumberTitle','off');
for k = 1:1:brojStepeniSlobode
    %Extremi
    Maximum=max(U(k,:));
    Minimum=min(U(k,:));

    %Trenutni grafik
    subplot(brojStepeniSlobode,1,k);
    plot(vektorVremenskihTrenutaka,U(k,:));
    grid;
    xlabel('t[s]');
    ylabel('u[m]');
    if tipNumerickeInteracije == 1
        title(strcat(num2str(k),' - stepen slobode: umax=',num2str(Maximum),...
            ' umin=',num2str(Minimum), ' - Metoda centralnih razlika'));
    elseif tipNumerickeInteracije == 2
        title(strcat(num2str(k),' - stepen slobode: umax=',num2str(Maximum),...
            ' umin=',num2str(Minimum), ' - NEWMARK a=const'));
    end
end
%Sila
figure('Name','Sila','NumberTitle','off');
for k = 1:1:brojStepeniSlobode
    %Trenutni grafik
    subplot(brojStepeniSlobode,1,k);
    plot(vektorVremenskihTrenutaka,P(k,:));
    title(strcat('Sila:',num2str(k),' stepen slobode'));
    grid;
    xlabel('t[s]');
    ylabel('P[kN]');
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%